export CUDA_VISIBLE_DEVICES="0"

# Run pretraining for no HRR
declare -a seeds=(42 0 100)

for seed in ${seeds[@]}; do
    tsp python3 BERTHA_Pretrain_save_5_epochs.py \
    --use_random_embeddings \
    --epochs=100 \
    --seed=$seed \
    --save_epochs=20 \
    --output_log_folder='./output/' \
    --tokenizer='./tokenizer-mimic-iv-icd-final' \
    --pretraining_dataset='./data/Pretraining'
done

# Run pretraining for HRR
declare -a seeds=(42 0 100)

for seed in ${seeds[@]}; do
    tsp python3 BERTHA_Pretrain_save_5_epochs.py \
    --dp_type=words_rv --dp_composition=snomed_all --snomed_group=group_vectors \
    --epochs=100 \
    --seed=$seed \
    --save_epochs=20 \
    --output_log_folder='./output/' \
    --tokenizer='./tokenizer-mimic-iv-icd-final' \
    --pretraining_dataset='./data/Pretraining'
done

# Run pretraining for HRRAdd
declare -a seeds=(42 0 100)

for seed in ${seeds[@]}; do
    tsp python3 BERTHA_Pretrain_save_5_epochs.py \
    --dp_type=words_rv --dp_composition=snomed_all --snomed_group=group_vectors \
    --use_cls=hrr \
    --epochs=100 \
    --seed=$seed \
    --save_epochs=20 \
    --output_log_folder='./output/' \
    --tokenizer='./tokenizer-mimic-iv-icd-final' \
    --pretraining_dataset='./data/Pretraining'
done

# Run pretraining for HRRCat
declare -a seeds=(42 0 100)

for seed in ${seeds[@]}; do
    tsp python3 BERTHA_Pretrain_save_5_epochs.py \
    --dp_type=words_rv --dp_composition=snomed_all --snomed_group=group_vectors \
    --use_cls=cat \
    --epochs=100 \
    --seed=$seed \
    --save_epochs=20 \
    --output_log_folder='./output/' \
    --tokenizer='./tokenizer-mimic-iv-icd-final' \
    --pretraining_dataset='./data/Pretraining'
done
